/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.json;

import com.aptana.core.logging.IdeLog;
import com.aptana.json.Schema;
import com.aptana.json.SchemaContext;
import com.aptana.json.SchemaEventType;
import com.aptana.parsing.ParsingPlugin;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.Plugin;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SchemaReader
implements ContentHandler {
    private Schema _schema;
    private SchemaContext _context;

    public SchemaReader(Schema schema) {
        this._schema = schema;
    }

    protected SchemaReader() {
    }

    public boolean endArray() {
        if (this._schema != null) {
            this._schema.transition(this._context, SchemaEventType.END_ARRAY, null);
        }
        return true;
    }

    public void endJSON() {
        if (this._schema != null) {
            this._schema.transition(this._context, SchemaEventType.END_PARSE, null);
            this._schema.exit();
        }
    }

    public boolean endObject() {
        if (this._schema != null) {
            this._schema.transition(this._context, SchemaEventType.END_OBJECT, null);
        }
        return true;
    }

    public boolean endObjectEntry() {
        if (this._schema != null) {
            this._schema.transition(this._context, SchemaEventType.END_OBJECT_ENTRY, null);
        }
        return true;
    }

    public SchemaContext getContext() {
        return this._context;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public boolean primitive(Object value) {
        if (this._schema != null) {
            this._schema.transition(this._context, SchemaEventType.PRIMITIVE, value);
        }
        return true;
    }

    public void read(Reader input, SchemaContext context) {
        this._context = context;
        JSONParser parser = new JSONParser();
        try {
            parser.parse(input, (ContentHandler)this);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)ParsingPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            IdeLog.logError((Plugin)ParsingPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
        }
        this._context = null;
    }

    protected void setSchema(Schema schema) {
        this._schema = schema;
    }

    public boolean startArray() {
        if (this._schema != null) {
            this._schema.transition(this._context, SchemaEventType.START_ARRAY, null);
        }
        return true;
    }

    public void startJSON() {
        if (this._schema != null) {
            this._schema.enter();
            this._schema.transition(this._context, SchemaEventType.START_PARSE, null);
        }
    }

    public boolean startObject() {
        if (this._schema != null) {
            this._schema.transition(this._context, SchemaEventType.START_OBJECT, null);
        }
        return true;
    }

    public boolean startObjectEntry(String key) {
        if (this._schema != null) {
            this._schema.transition(this._context, SchemaEventType.START_OBJECT_ENTRY, key);
        }
        return true;
    }
}

